<?php

namespace Modules\Example\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Modules\Example\Entities\Example;
use Modules\Example\Http\Requests\ExampleRequest;
use Maatwebsite\Excel\Facades\Excel;
use Modules\Example\Exports\ExampliesExport;

class AdminController extends Controller
{
    public function __construct()
    {
        $this->authorizeResource(Example::class, 'example');
    }

    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $data = Example::query()
                ->filters($request);

            return Example::makeDataTable($data);
        }

        return view('example::admin.index');
    }

    public function trashed(Request $request)
    {
        $this->authorize('restore', Example::class);

        if ($request->ajax()) {
            $data = Example::query()
                ->onlyTrashed();

            return Example::makeDataTable($data, trash: true);
        }

        return view('example::admin.trashed');
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('example::admin.create', ['example' => new Example()]);
    }

    /**
     * Store a newly created example in storage
     *
     * @param  \Modules\Example\Http\Requests\ExampleRequest $request
     * @param  \Modules\Example\Entities\Example $example
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(ExampleRequest $request, Example $example)
    {
        $example->create(array_merge($request->validated(), [
            'thumbnail' => upload_file($request, 'thumbnail', 'example/thumbnails'),
            'is_active' => $request->boolean('is_active'),
        ]));

        return redirect()->route('example.index')->withStatus(__('New example successfully created.'));
    }

    /**
     * Show the form for editing the specified example
     *
     * @param  \Modules\Example\Entities\Example $example
     * @return \Illuminate\View\View
     */
    public function edit(Example $example)
    {
        return view('example::admin.edit', ['example' => $example]);
    }

    /**
     * Update the specified example in storage
     *
     * @param  \Modules\Example\Http\Requests\ExampleRequest $request
     * @param  \Modules\Example\Entities\Example $example
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(ExampleRequest $request, Example $example)
    {
        $example->update(array_merge($request->validated(), [
            'thumbnail' => upload_file($request, 'thumbnail', 'example/thumbnails', $example->thumbnail),
            'is_active' => $request->boolean('is_active'),
        ]));

        return redirect()->route('example.index')->withStatus(__("Example #$example->id successfully updated."));
    }

    /**
     * Remove the specified example from storage
     *
     * @param  \Modules\Example\Entities\Example $example
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy(Example $example)
    {
        $example->delete();

        return redirect()->route('example.index')->withStatus(__("Example #$example->id successfully deleted."));
    }

    public function restore($id)
    {
        $example = Example::onlyTrashed()->findOrFail($id);

        $this->authorize('restore', $example);

        if ($example->trashed()) {
            $example->restore();

            return redirect()->route('example.trashed')->withStatus(__("Example #$example->id successfully restored."));
        }

        return redirect()->route('example.trashed')->withErrors(__("Example #$example->id cannot be restored."));
    }

    public function export(Request $request)
    {
        $this->authorize('export', Example::class);

        return Excel::download(new ExampliesExport($request), 'examplies-' . now()->format('dmY_His') . '.xlsx');
    }
}
