<?php

namespace Modules\Event\Transformers;

use Illuminate\Http\Resources\Json\JsonResource;
use Modules\Event\Entities\EventSchedule;
use Modules\Speaker\Transformers\SpeakerResource;

class ScheduleResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'hash' => $this->hash_id,
            'title' => $this->title,
            'description' => $this->description,
            'tag' => EventSchedule::listTags()[$this->tags] ?? null,
            'venue' => $this->venue,
            'date_formatted' => date_formatted($this->date),
            'start_time_formatted' => time_formatted($this->start_time, 'H:i'),
            'end_time_formatted' => time_formatted($this->end_time, 'H:i'),
            'speakers' => SpeakerResource::collection($this->activeSpeakers()->get()),
        ];
    }
}
