<?php

namespace Modules\Event\Transformers;

use Illuminate\Http\Resources\Json\JsonResource;
use Modules\Event\Entities\EventPhoto;
use Modules\Feedback\Transformers\FeedbackResource;
use Modules\Speaker\Transformers\SpeakerResource;

class PhotoResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'hash' => $this->hash_id,
            'type' => $this->type,
            'thumbnail' => $this->thumbnail_path,
            'url' => $this->full_path,
        ];
    }
}
