<?php

namespace Modules\Event\Transformers;

use Illuminate\Http\Resources\Json\JsonResource;
use Modules\Feedback\Transformers\FeedbackResource;
use Modules\Speaker\Transformers\SpeakerResource;

class EventResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request
     * @return array
     */
    public function toArray($request)
    {
        $schedules = $this->activeSchedules?->groupBy('date') ?: collect();

        return [
            'hash' => $this->hash_id,
            'label' => $this->label,
            'title' => $this->title,
            'location' => $this->location,
            'timezone' => $this->timezone,
            'description' => $this->description,
            'banner_link' => $this->banner_path,
            'download_link' => $this->file_download_url,
            'start_date_timestamp' => $this->start_date?->timestamp,
            'end_date_timestamp' => $this->end_date?->timestamp,
            'start_date_formatted' => $start_date = $this->start_date?->format('d/m/Y'),
            'end_date_formatted' => $end_date = $this->end_date?->format('d/m/Y'),
            'start_date_year' => $this->start_date?->format('Y'),
            'end_date_year' => $this->end_date?->format('Y'),
            'full_date_formatted' => $start_date . ($end_date ? ' - ' . $end_date : ''),
            'gallery' => PhotoResource::collection($this->whenLoaded('activePhotos'))?->groupBy('type'),
            'speakers' => SpeakerResource::collection($this->whenLoaded('activeSpeakers')),
            'feedbacks' => FeedbackResource::collection($this->whenLoaded('approvedFeedbacks')),
            'schedules' => $schedules?->transform(fn($group) => $group->groupBy('full_time')->map(fn($items) => ScheduleResource::collection($items))),
            'related_events' => RelatedEventResource::collection($this->whenLoaded('activeRelatedEvents')),
            'enable_submit_feedback' => $this->enable_submit_feedback,
        ];
    }
}
