<?php

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

use Modules\Event\Http\Controllers\Api\AllEventsController;
use Modules\Event\Http\Controllers\Api\FeaturedEventsController;
use Modules\Event\Http\Controllers\Api\PastEventsController;
use Modules\Event\Http\Controllers\Api\ReloadEventController;
use Modules\Event\Http\Controllers\Api\SubmitFeedbackEventController;
use Modules\Event\Http\Controllers\Api\SubmitParticipantEventController;
use Modules\Event\Http\Controllers\Api\UpcomingEventsController;

Route::middleware([
    //
])->prefix('events')->group(function () {
    Route::get('reload/{hash}', ReloadEventController::class);
    Route::get('all', AllEventsController::class);
    Route::get('featured', FeaturedEventsController::class);
    Route::get('upcoming', UpcomingEventsController::class);
    Route::get('past', PastEventsController::class);
    Route::post('apply/{event}', SubmitParticipantEventController::class);
    Route::post('feedback/{event}', SubmitFeedbackEventController::class);
});
