<?php

use Illuminate\Support\Facades\Route;
use Modules\Event\Http\Controllers\AdminController;

Route::prefix('event')->name('event.')->group(function () {
    Route::controller(AdminController::class)->group(function () {
        Route::get('/', 'index')->name('index');

        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');

        Route::get('{event}/edit', 'edit')->name('edit');
        Route::put('{event}', 'update')->name('update');

        Route::prefix('{event}/gallery')->name('gallery.')->group(function () {
            Route::get('/', 'indexPhoto')->name('index');
            Route::post('upload', 'uploadPhoto')->name('upload');
            Route::get('{photo}/edit', 'editPhoto')->name('edit');
            Route::put('{photo}', 'updatePhoto')->name('update');
            Route::delete('{photo}', 'destroyPhoto')->name('destroy');
        });

        Route::prefix('{event}/schedule')->name('schedule.')->group(function () {
            Route::get('/', 'indexSchedule')->name('index');
            Route::post('store', 'storeSchedule')->name('store');
            Route::post('update', 'updateSchedule')->name('update');
            Route::get('{schedule}/form', 'formSchedule')->name('form');
            Route::put('{schedule}/edit', 'editSchedule')->name('edit');
            Route::delete('{schedule}', 'destroySchedule')->name('destroy');
        });

        Route::prefix('{event}/participants')->name('users.')->group(function () {
            Route::get('/', 'indexUsers')->name('index');
        });

        Route::delete('{event}', 'destroy')->name('destroy');

        Route::get('trashed', 'trashed')->name('trashed');
        Route::post('restore/{id}', 'restore')->name('restore');

        Route::get('export', 'export')->name('export');
    });
});
