@extends('admin.layouts.base', [
    'title' => __(':event Participants', ['event' => $event->title]),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-user-group fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('event.index') }}">{{ __('Events') }}</a></li>
        <li class="breadcrumb-item"><a href="{{ route('event.edit', $event) }}">{{ $event->title }}</a></li>
        <li class="breadcrumb-item text-white active" aria-current="page">{{ __('Participants') }}</li>

        @slot('buttons')
            <a href="{{ route('event.edit', $event) }}" class="btn btn-sm btn-neutral">{{ __('Back') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
<div class="position-relative container-fluid mt--8">
    <div class="card">
        @component('admin.components.filter')
            @slot('status', null)

            <div class="px-3 py-2">
                <label class="form-control-label" for="filterEvent">{{ __('Filter Event') }}</label>
                <select class="form-control" name="event" id="filterEvent" data-toggle="select">
                    <option value="all">{{ __('All') }}</option>
                    @foreach ($events as $id => $name)
                        <option value="{{ $id }}" @selected(request()->query('event') == $id)>{{ $name }}</option>
                    @endforeach
                </select>
            </div>
        @endcomponent

        <div class="py-4">
            <table id="tableEvent" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        <th>{{ __('Event') }}</th>
                        <th>{{ __('Name') }}</th>
                        <th>{{ __('Designation') }}</th>
                        <th>{{ __('Email') }}</th>
                        <th>{{ __('Contact No.') }}</th>
                        <th>{{ __('Company') }}</th>
                        <th>{{ __('Created At') }}</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'Event',
    'route' => route('event.users.index', $event),
    'columns' => [
        get_dt_column_config('DT_RowIndex', 'id', orderable: false, searchable: false),
        get_dt_column_config('event', 'event.title'),
        get_dt_column_config('name'),
        get_dt_column_config('designation'),
        get_dt_column_config('email'),
        get_dt_column_config('contact_no'),
        get_dt_column_config('company'),
        get_dt_column_config('created_at', searchable: false),
    ]
])

@push('js')
    <script nonce="{{ csp_nonce('script') }}">
        $("#filterEvent").on('change', function (ev) {
            const urlParams = new URLSearchParams(window.location.search);

            if ($(this).val() != 'all') {
                urlParams.set('event', $(this).val());
            } else {
                urlParams.delete('event');
            }

            window.location.search = urlParams;
        });
    </script>
@endpush
