@inject('event', Modules\Event\Entities\Event::class)

@extends('admin.layouts.base', [
    'title' => __('Events Trashed'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-calendar-day fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('event.index') }}">{{ __('Events') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('Trashed') }}</li>

        @slot('buttons')
            <a href="{{ route('event.index') }}" class="btn btn-sm btn-neutral">{{ __('List All') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
<div class="container-fluid mt--8">
    <div class="card">
        <div class="py-4">
            <table id="tableEvent" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        @canany(['restore'], $event)
                            <th>{{ __('Actions') }}</th>
                        @endcanany
                        <th>{{ __('Banner') }}</th>
                        <th>{{ __('Title') }}</th>
                        <th>{{ __('Location') }}</th>
                        <th>{{ __('Gallery') }}</th>
                        <th>{{ __('Speakers') }}</th>
                        <th>{{ __('Participants') }}</th>
                        <th>{{ __('Feedbacks') }}</th>
                        <th>{{ __('Start Date') }}</th>
                        <th>{{ __('End Date') }}</th>
                        <th>{{ __('Schedule PDF') }}</th>
                        <th>{{ __('Description') }}</th>
                        <th>{{ __('Featured') }}</th>
                        <th>{{ __('Feedback') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Deleted At') }}</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'Event',
    'route' => route('event.trashed'),
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $event, can: ['restore']),
        get_dt_column_config('banner', orderable: false, searchable: false),
        get_dt_column_config('title'),
        get_dt_column_config('location'),
        get_dt_column_config('photos_count', searchable: false),
        get_dt_column_config('speakers_count', searchable: false),
        get_dt_column_config('participants_count', searchable: false),
        get_dt_column_config('feedbacks_count', searchable: false),
        get_dt_column_config('start_date'),
        get_dt_column_config('end_date'),
        get_dt_column_config('file', orderable: false, searchable: false),
        get_dt_column_config('description'),
        get_dt_column_config('feature', 'is_featured', searchable: false),
        get_dt_column_config('feedback', 'enable_submit_feedback', searchable: false),
        get_dt_column_config('status', 'is_active', searchable: false),
        get_dt_column_config('deleted_at', searchable: false),
    ]
])
