@inject('schedule', Modules\Event\Entities\EventSchedule::class)

@extends('admin.layouts.base', [
    'title' => __(':event Schedule', ['event' => $event->title]),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('bags', [
            'default',
            'modal',
        ])

        @slot('title')
            <i class="fas fa-clock fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('event.index') }}">{{ __('Events') }}</a></li>
        <li class="breadcrumb-item"><a href="{{ route('event.edit', $event) }}">{{ $event->title }}</a></li>
        <li class="breadcrumb-item text-white active" aria-current="page">{{ __('Schedule') }}</li>

        @slot('buttons')
            <a href="{{ route('event.edit', $event) }}" class="btn btn-sm btn-neutral">
                <i class="fas fa-edit mr-2"></i>
                {{ __('Edit') }}
            </a>
        @endslot
    @endcomponent
@endsection

@section('content')
    <div class="container-fluid mt--8">
        <div class="row">
            <div class="col-12 col-md-7">
                @component('admin.components.card')
                    @slot('title', __(':event Schedule', ['event' => $event->title]))

                    <div id="agendas-sortable" class="list-group nested-sortable">
                        @foreach ($schedules as $date => $agendas)
                            <div class="list-group-item border nested-padding" data-id="{{ $date }}">
                                <div class="d-flex align-items-center">
                                    <h2 class="mb-0">{{ __('Day :day', ['day' => $loop->iteration]) }}&nbsp;&nbsp;<small class="text-muted">{{ date_formatted($date, 'd F Y') }}</small></h2>
                                </div>

                                <div @class(['list-group nested-sortable', 'mt-3' => $agendas->isNotEmpty()])>
                                    @foreach ($agendas as $item)
                                        <div class="nested-padding bg-lighter rounded" data-id="{{ $item->id }}">
                                            <div class="px-2 pt-1 text-muted overflow-hidden">
                                                <small class="px-2 pb-1 d-inline-block">{{ __('Time') }}: <strong>{{ time_formatted($item->start_time) }} - {{ time_formatted($item->end_time) }}</strong></small>
                                                <small class="px-2 pb-1 d-inline-block">{{ __('Venue') }}: <strong>{{ $item->venue ?: '-' }}</strong></small>
                                                @if ($tags = $item->tags)
                                                    <small class="px-2 pb-1 d-inline-block">{{ __('Tags') }}: <strong>{{ $schedule::listTags()[$item->tags] }}</strong></small>
                                                @endif
                                            </div>
                                            <div class="input-group mb-0">
                                                <div class="input-group-prepend">
                                                    <div class="input-group-text pl-3 pr-0">
                                                        <div class="grabbing mr-3" data-placement="right" data-toggle="tooltip" title="Drag">
                                                            <i class="fas fa-arrows-alt text-primary"></i>
                                                        </div>

                                                        <div class="mr-3" data-placement="right" data-toggle="tooltip" title="Edit">
                                                            <a role="button" href="#scheduleFormModal" data-id="{{ $item->id }}" data-hash="{{ $item->hash_id }}" data-toggle="modal">
                                                                <i class="fas fa-edit text-primary"></i>
                                                            </a>
                                                        </div>

                                                        <form action="{{ route('event.schedule.destroy', [$event, $item]) }}" class="need-confirm mr-3" method="post">
                                                            @method('delete')
                                                            @csrf
                                                            <button type="submit" class="btn-trash table-action table-action-delete border-0 bg-transparent px-0" data-placement="right" data-toggle="tooltip" title="Delete">
                                                                <i class="fas fa-trash"></i>
                                                            </button>
                                                        </form>
                                                    </div>
                                                </div>
                                                <input type="text" class="form-control h-auto bg-white" name="title" value="{{ $item->title }}" readonly>
                                                <div class="input-group-append">
                                                    <div class="input-group-text align-items-stretch">
                                                        <span class="badge badge-pill badge-info mr-2 py-1" style="line-height: 1rem;" data-placement="right" data-toggle="tooltip" title="Speakers">{{ $item->speakers_count }}</span>
                                                        <label class="custom-toggle" data-placement="right" data-toggle="tooltip" title="Status Active">
                                                            <input type="checkbox" name="is_active" value="1" {{ $item->is_active ? 'checked' : '' }}>
                                                            <span class="custom-toggle-slider rounded-circle" data-label-off="No" data-label-on="Yes"></span>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endforeach
                    </div>

                    <form method="post" action="{{ route('event.schedule.update', $event) }}">
                        @csrf
                        <input type="hidden" name="agendas" id="input-agendas" value="">
                        <div class="text-center mt-4">
                            <button type="submit" id="agendas-update" class="btn btn-success" disabled>
                                <i class="fas fa-save mr-2"></i> {{ __('Update') }}
                            </button>
                        </div>
                    </form>
                @endcomponent
            </div>
            <div class="col-12 col-md-5">
                @component('admin.components.form')
                    @slot('title', __('New Schedule'))
                    @slot('route', route('event.schedule.store', $event))
                    @include('event::admin.schedule.form', ['bag' => 'default', 'schedule' => $schedule])
                @endcomponent
            </div>
        </div>
    </div>
@endsection

@push('modals')
    <div class="modal fade" id="scheduleFormModal" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="scheduleFormModalLabel" aria-hidden="true" data-focus="false">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header align-items-center">
                    <h3 class="modal-title mb-0" id="scheduleFormModalLabel">{{ __('Edit Schedule') }}</h3>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="scheduleForm" action="" method="post" class="row">
                        @if ($errors->modal->any())
                            @include('event::admin.schedule.form', ['bag' => 'modal', 'form' => true, 'schedule' => $schedule])
                        @else
                            <div class="col d-flex align-items-center justify-content-center py-5">
                                <i class="fas fa-sync fa-spin fa-4x text-primary"></i>
                            </div>
                        @endif
                    </form>
                </div>
            </div>
        </div>
    </div>
@endpush

@push('vendor-css')
    <link rel="stylesheet" href="{{ basset_url('argon/vendor/select2/dist/css/select2.min.css') }}" nonce="{{ csp_nonce('style') }}">
    <link rel="stylesheet" href="{{ basset_url('argon/vendor/flatpickr/flatpickr.min.css') }}" nonce="{{ csp_nonce('style') }}">
@endpush

@push('css')
    @bassetBlock('admin/css/agendas-sortable.css')
        <style>
            .nested-padding + .nested-padding {
                margin-top: 8px;
                border-top-width: 1px;
            }

            .grabbing {
                cursor: grab;
            }
        </style>
    @endBassetBlock()
@endpush

@push('vendor-js')
    <script src="{{ basset_url('argon/vendor/select2/dist/js/select2.full.min.js') }}" nonce="{{ csp_nonce('script') }}"></script>
    <script src="{{ basset_url('argon/vendor/flatpickr/flatpickr.min.js') }}" nonce="{{ csp_nonce('script') }}"></script>
    <script src="{{ basset_url('https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js') }}" nonce="{{ csp_nonce('script') }}"></script>
@endpush

@push('js')
    @bassetBlock('admin/js/agendas-sortable.js')
        <script nonce="{{ basset_nonce('script') }}">
            $(document).ready(function() {
                var nestedSortables = document.getElementsByClassName('nested-sortable');

                for (var i = 0; i < nestedSortables.length; i++) {
                    new Sortable(nestedSortables[i], {
                        handle: '.grabbing',
                        group: 'nested',
                        animation: 150,
                        fallbackOnBody: true,
                        swapThreshold: 0.65,
                        onMove(event) {
                            const to = $(event.to);
                            const dragged = $(event.dragged);

                            // NOTE: to limit up to 2nd level menu only
                            const lvl = to.parents('.nested-sortable').length;

                            // NOTE: to block nested when itself have children
                            const children = dragged.find('.nested-padding').length;

                            if (lvl == 0) {
                                return false;
                            }

                            return true;
                        },
                        onEnd: handleSortEnd
                    });
                }
            });

            $('#agendas-sortable .nested-padding input').on('input', handleSortEnd);

            function handleSortEnd(event) {
                const item = $(event.item);
                const to = $(event.to);
                const from = $(event.from);

                const children = from.find('.nested-padding').length;

                if (children == 0) {
                    from.removeClass('mt-3');
                }

                if (!to.hasClass('mt-3')) {
                    to.addClass('mt-3');
                }

                var arraySortable = [];
                var agendasSortable = $('#agendas-sortable');
                var agendasSortableCount = agendasSortable.find('.nested-padding').length;

                var findChild = function(index, item, parent) {
                    if (arraySortable.length == agendasSortableCount) {
                        return;
                    }

                    if (item) {
                        var id = $(item).data('id');

                        if (parent != 0) {
                            arraySortable.push({
                                date: parent,
                                position: arraySortable.length,
                                id,
                                title: $(item).find('input[name=title]').first().val(),
                                is_active: $(item).find('input[name=is_active]').first().is(':checked'),
                            });
                        }

                        const wrapper = $(item).find('.nested-sortable');

                        wrapper.children('.nested-padding').each(function(index, item) {
                            findChild(index, item, id);
                        });
                    }
                }

                agendasSortable.children('.nested-padding').each(function(index, item) {
                    findChild(index, item, 0);
                });

                if (arraySortable.length) {
                    $('#input-agendas').val(JSON.stringify(arraySortable));
                    $('#agendas-update').prop('disabled', false);
                } else {
                    $('#input-agendas').val('');
                    $('#agendas-update').prop('disabled', true);
                }
            }
        </script>
    @endBassetBlock()

    <script nonce="{{ csp_nonce('script') }}">
        @if ($errors->modal->any())
            $('#scheduleFormModal').modal('show');
        @endif

        $('#scheduleFormModal').on('show.bs.modal', function (event) {
            if (event.relatedTarget) {
                $('#scheduleForm').html('<div class="col d-flex align-items-center justify-content-center py-5"><i class="fas fa-sync fa-spin fa-4x text-primary"></i>');
            }
        });

        $('#scheduleFormModal').on('shown.bs.modal', function (event) {
            const $this = $(this);
            const form = $('#scheduleForm');
            const route = "{{ route('event.schedule.edit', [$event, '#']) }}";

            let id = "{{ old('id') }}";
            let hash = "{{ old('hash') }}";

            if (event.relatedTarget) {
                id = event.relatedTarget.getAttribute('data-id');
                hash = event.relatedTarget.getAttribute('data-hash');
            }

            form.prop('action', route.replace('#', hash));

            $('#scheduleFormModalLabel').text(`{{ __('Edit Schedule #') }}${id}`);

            if (event.relatedTarget) {
                $.ajax({
                    url: ("{{ route('event.schedule.form', [$event, '#']) }}").replace('#', hash),
                    method: 'get',
                    success: function (response) {
                        form.html(response);
                        initFlatpickr('modal');
                        initSelectTwo('modal');
                        initTinyMCE('-modal');
                    },
                    error: function (error) {
                        console.error(error);
                        form.html('<div class="col d-flex align-items-center justify-content-center py-5"><i class="fas fa-triangle-exclamation fa-4x text-danger"></i></div>');
                    },
                    complete: function () {
                        //
                    }
                });
            } else {
                initFlatpickr('modal');
                initSelectTwo('modal');
                initTinyMCE('-modal');
            }
        });

        $('#scheduleFormModal').on('hide.bs.modal', function (event) {
            initSelectTwo('default');
        });

        function initFlatpickr(bag) {
            const flatpickrStart = $(`.flatpickr-${bag}-start`).flatpickr({
                enableTime: true,
                noCalendar: true,
                // time_24hr: true,
                altInput: true,
                altFormat: 'h:i K',
                dateFormat: 'H:i',
            });

            const flatpickrEnd = $(`.flatpickr-${bag}-end`).flatpickr({
                enableTime: true,
                noCalendar: true,
                // time_24hr: true,
                altInput: true,
                altFormat: 'h:i K',
                dateFormat: 'H:i',
            });

            flatpickrStart.config.onChange.push(function(selectedDates, dateStr, instance) {
                if (dateStr) {
                    flatpickrEnd.set('minTime', dateStr);
                }
            });

            flatpickrEnd.config.onChange.push(function(selectedDates, dateStr, instance) {
                if (dateStr) {
                    //
                }
            });
        }

        function initSelectTwo(bag) {
            $(`.select2-${bag}`).select2({
                placeholder: "Please Select",
            });
        }

        initFlatpickr('default');
        initSelectTwo('default');
    </script>
@endpush
