<div class="col-12 form-group">
    <label class="form-control-label" for="input-date">{{ __('Date') }} <sup class="text-danger">*</sup></label>
    <select name="date" id="input-date" class="form-control {{ $errors->{$bag}->has('date') ? 'is-invalid' : '' }}" placeholder="{{ __('Please Select Date') }}" required>
        <option value="">{{ __('Please Select Date') }}</option>
        @foreach ($event->dateRange() as $date => $label)
            <option value="{{ $date }}" @selected(old('date', $schedule?->date) == $date)>{{ $label }}</option>
        @endforeach
    </select>
    @include('alerts.feedback', ['bag' => $bag, 'field' => 'date'])
</div>

<div class="col-12 form-group">
    <label class="form-control-label" for="input-title">{{ __('Title') }} <sup class="text-danger">*</sup></label>
    <div class="{{ $errors->{$bag}->has('title') ? 'has-danger' : '' }}">
        <textarea name="title" id="input-title" class="form-control {{ $errors->{$bag}->has('title') ? 'is-invalid' : '' }}" cols="30" rows="5" placeholder="{{ __('Title') }}" required>{{ old('title', $schedule?->title) }}</textarea>
    </div>
    @include('alerts.feedback', ['bag' => $bag, 'field' => 'title'])
</div>

<div class="col-12 px-0">
    @include('admin.components.tinymce', ['editors' => ['Description' => 'description'], 'model' => $schedule, 'append' => ($form ?? false) ? '-modal' : ''])
</div>

<div class="col-12 form-group">
    <label class="form-control-label" for="input-venue">{{ __('Venue') }}</label>
    <div class="{{ $errors->{$bag}->has('venue') ? 'has-danger' : '' }}">
        <input type="text" name="venue" id="input-venue" class="form-control {{ $errors->{$bag}->has('venue') ? 'is-invalid' : '' }}" maxlength="100" placeholder="{{ __('Venue') }}" value="{{ old('venue', $schedule?->venue) }}">
    </div>
    @include('alerts.feedback', ['bag' => $bag, 'field' => 'venue'])
</div>

<div class="col-md-6 form-group">
    <label class="form-control-label" for="input-start_time">{{ __('Start Time') }} <sup class="text-danger">*</sup></label>
    <div class="{{ $errors->{$bag}->has('start_time') ? 'has-danger' : '' }}">
        <input type="text" name="start_time" id="input-start_time" class="flatpickr-{{ $bag }}-start form-control bg-white {{ $errors->{$bag}->has('start_time') ? 'is-invalid' : '' }}" placeholder="{{ __('Start Time') }}" value="{{ old('start_time', $schedule?->start_time) }}" required>
    </div>
    @include('alerts.feedback', ['bag' => $bag, 'field' => 'start_time'])
</div>

<div class="col-md-6 form-group">
    <label class="form-control-label" for="input-end_time">{{ __('End Time') }} <sup class="text-danger">*</sup></label>
    <div class="{{ $errors->{$bag}->has('end_time') ? 'has-danger' : '' }}">
        <input type="text" name="end_time" id="input-end_time" class="flatpickr-{{ $bag }}-end form-control bg-white {{ $errors->{$bag}->has('end_time') ? 'is-invalid' : '' }}" placeholder="{{ __('End Time') }}" value="{{ old('end_time', $schedule?->end_time) }}" required>
    </div>
    @include('alerts.feedback', ['bag' => $bag, 'field' => 'end_time'])
</div>

<div class="col-12 form-group">
    <label class="form-control-label" for="input-speakers">{{ __('Speakers') }}</label>
    <select name="speakers[]" id="input-speakers" class="select2-{{ $bag }} form-control {{ $errors->{$bag}->has('speakers') ? 'is-invalid' : '' }}" placeholder="{{ __('Please Select Speaker') }}" multiple>
        <option value="">{{ __('Please Select Speaker') }}</option>
        @foreach ($speakers as $id => $name)
            <option value="{{ $id }}" @selected(in_array($id, old('speakers', $schedule?->exists ? $schedule?->speakers()->pluck('id')->toArray() : [])))>{{ $name }}</option>
        @endforeach
    </select>
    @include('alerts.feedback', ['bag' => $bag, 'field' => 'speakers'])
</div>

<div class="col-12 form-group">
    <label class="form-control-label" for="input-tags">{{ __('Tags') }}</label>
    <select name="tags" id="input-tags" class="form-control {{ $errors->{$bag}->has('tags') ? 'is-invalid' : '' }}" placeholder="{{ __('Please Select Tag') }}">
        <option value="">{{ __('Please Select Tag') }}</option>
        @foreach ($schedule::listTags() as $val => $label)
            <option value="{{ $val }}" @selected(old('tags', $schedule?->tags) == $val)>{{ $label }}</option>
        @endforeach
    </select>
    @include('alerts.feedback', ['bag' => $bag, 'field' => 'tags'])
</div>

<div class="col-12 form-group d-flex align-items-center">
    <label class="form-control-label mb-0 mr-3">{{ __('Status Active') }} <sup class="text-danger">*</sup></label>
    <label class="custom-toggle">
        <input type="checkbox" name="is_active" value="1" {{ old('is_active', $schedule?->is_active) ? 'checked' : '' }}>
        <span class="custom-toggle-slider rounded-circle" data-label-off="No" data-label-on="Yes"></span>
    </label>
</div>

@isset($form)
    @csrf
    @method('put')

    <input type="hidden" name="id" value="{{ $schedule->id }}">
    <input type="hidden" name="hash" value="{{ $schedule->hash_id }}">

    <div class="col-12 text-center mt-4">
        <button type="submit" class="btn btn-success">
            <i class="fas fa-save mr-2"></i>{{ __('Update') }}
        </button>
    </div>
@endisset
