@inject('event', Modules\Event\Entities\Event::class)

@extends('admin.layouts.base', [
    'title' => __('Events Management'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-calendar-day fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('event.index') }}">{{ __('Events') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('List All') }}</li>

        @slot('buttons')
            @can('create', $event)
                <a href="{{ route('event.create') }}" class="btn btn-sm btn-neutral">{{ __('Create New') }}</a>
            @endcan

            @can('export', $event)
                <a href="{{ route('event.export', request()->query()) }}" class="btn btn-sm btn-primary">{{ __('Export Excel') }}</a>
            @endcan
        @endslot
    @endcomponent
@endsection

@section('content')
<div class="position-relative container-fluid mt--8">
    <div class="card">
        @component('admin.components.filter')
            @slot('status', true)

            <div class="px-3 py-2">
                <label class="form-control-label" for="filterFeatured">{{ __('Filter Featured') }}</label>
                <select class="form-control" name="featured" id="filterFeatured" data-toggle="select">
                    <option value="all">{{ __('All') }}</option>
                    @foreach (['yes', 'no'] as $label)
                        <option value="{{ $label }}" @selected(request()->query('featured') == $label)>{{ ucwords($label) }}</option>
                    @endforeach
                </select>
            </div>

            <div class="px-3 py-2">
                <label class="form-control-label" for="filterFeedback">{{ __('Filter Submit Feedback') }}</label>
                <select class="form-control" name="feedback" id="filterFeedback" data-toggle="select">
                    <option value="all">{{ __('All') }}</option>
                    @foreach (['enabled', 'disabled'] as $label)
                        <option value="{{ $label }}" @selected(request()->query('feedback') == $label)>{{ ucwords($label) }}</option>
                    @endforeach
                </select>
            </div>

            <div class="px-3 py-2">
                <label class="form-control-label" for="filterSpeaker">{{ __('Filter Speaker') }}</label>
                <select class="form-control" name="speaker" id="filterSpeaker" data-toggle="select">
                    <option value="all">{{ __('All') }}</option>
                    @foreach ($speakers as $id => $name)
                        <option value="{{ $id }}" @selected(request()->query('speaker') == $id)>{{ $name }}</option>
                    @endforeach
                </select>
            </div>
        @endcomponent

        <div class="py-4">
            <table id="tableEvent" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        @canany(['update', 'delete'], $event)
                            <th>{{ __('Actions') }}</th>
                        @endcanany
                        <th>{{ __('Banner') }}</th>
                        <th>{{ __('Title') }}</th>
                        <th>{{ __('Location') }}</th>
                        <th>{{ __('Gallery') }}</th>
                        <th>{{ __('Speakers') }}</th>
                        <th>{{ __('Participants') }}</th>
                        <th>{{ __('Feedbacks') }}</th>
                        <th>{{ __('Start Date') }}</th>
                        <th>{{ __('End Date') }}</th>
                        <th>{{ __('Schedule PDF') }}</th>
                        <th>{{ __('Description') }}</th>
                        <th>{{ __('Featured') }}</th>
                        <th>{{ __('Feedback') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Created At') }}</th>
                        <th>{{ __('Updated At') }}</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'Event',
    'route' => route('event.index'),
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $event, can: ['update', 'delete']),
        get_dt_column_config('banner', orderable: false, searchable: false),
        get_dt_column_config('title'),
        get_dt_column_config('location'),
        get_dt_column_config('photos_count', searchable: false),
        get_dt_column_config('speakers_count', searchable: false),
        get_dt_column_config('participants_count', searchable: false),
        get_dt_column_config('feedbacks_count', searchable: false),
        get_dt_column_config('start_date'),
        get_dt_column_config('end_date'),
        get_dt_column_config('file', orderable: false, searchable: false),
        get_dt_column_config('description'),
        get_dt_column_config('feature', 'is_featured', searchable: false),
        get_dt_column_config('feedback', 'enable_submit_feedback', searchable: false),
        get_dt_column_config('status', 'is_active', searchable: false),
        get_dt_column_config('created_at', searchable: false),
        get_dt_column_config('updated_at', searchable: false),
    ]
])

@push('js')
    <script nonce="{{ csp_nonce('script') }}">
        $("#filterFeatured").on('change', function (ev) {
            const urlParams = new URLSearchParams(window.location.search);

            if ($(this).val() != 'all') {
                urlParams.set('featured', $(this).val());
            } else {
                urlParams.delete('featured');
            }

            window.location.search = urlParams;
        });

        $("#filterFeedback").on('change', function (ev) {
            const urlParams = new URLSearchParams(window.location.search);

            if ($(this).val() != 'all') {
                urlParams.set('feedback', $(this).val());
            } else {
                urlParams.delete('feedback');
            }

            window.location.search = urlParams;
        });

        $("#filterSpeaker").on('change', function (ev) {
            const urlParams = new URLSearchParams(window.location.search);

            if ($(this).val() != 'all') {
                urlParams.set('speaker', $(this).val());
            } else {
                urlParams.delete('speaker');
            }

            window.location.search = urlParams;
        });
    </script>
@endpush
