<div class="mt-4">
    @component('admin.components.form')
        @slot('id', 'eventPhotosUpload')
        @slot('title', __('Upload Multiple Photos/Videos'))
        @slot('route', route('event.gallery.upload', $event))

        <div class="col-12">
            <small class="form-text text-muted mt-0 mb-3">
                {!! __('Only <strong>:mimes</strong> extension allowed with maximum of <strong>:maxsize</strong> in file size', ['mimes' => $mimes ?? 'PNG, JPEG, JPG, MP4, MOV', 'maxsize' => in_filesize($maxsize ?? config('app.max_file_size'))]) !!}
            </small>
            <div id="dropzonePhotos" class="dropzone dropzone-multiple">
                <div class="fallback">
                    <div class="custom-file">
                        <input type="file" name="file" class="custom-file-input file-upload" id="customFileUploadMultiple">
                        <label class="custom-file-label" for="customFileUploadMultiple">{{ __('Choose File') }}</label>
                    </div>
                </div>

                <ul class="dz-preview dz-preview-multiple list-group list-group-lg list-group-flush">
                    <li class="list-group-item px-0">
                        <div class="row align-items-center">
                            <div class="col-auto align-self-start">
                                <div class="avatar mt-1">
                                    <img class="avatar-img rounded" src="" alt="" data-dz-thumbnail>
                                </div>
                            </div>
                            <div class="col ml--3">
                                <h4 class="mb-0" data-dz-name></h4>
                                <p class="small text-muted mb-0" data-dz-size></p>
                                <p class="text-danger font-weight-bold mb-0" data-dz-errormessage></p>
                                <p class="text-success font-weight-bold mb-0" data-dz-successmessage></p>

                                <div class="progress mb-0 mt-2">
                                    <div class="progress-bar progress-bar-striped progress-bar-animated bg-success" data-dz-uploadprogress role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                            </div>
                            <div class="col-auto ml--3">
                                <button type="button" class="close" aria-label="Close" data-dz-remove>
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        </div>
                    </li>
                </ul>
            </div>
        </div>

        @slot('button')
            <i class="fas fa-upload mr-2"></i>{{ __('Confirm & Upload') }}
        @endslot
    @endcomponent
</div>

@push('css')
@endpush

@push('vendor-js')
    <script src="{{ basset_url('argon/vendor/dropzone/dist/dropzone-v5.js') }}" nonce="{{ csp_nonce('script') }}"></script>
@endpush

@push('js')
    <script nonce="{{ basset_nonce('script') }}">
        Dropzone.autoDiscover = false;

        const $dropzone = $("#dropzonePhotos");
        const $dropzonePreview = $dropzone.find(".dz-preview");

        $dropzone.dropzone({
            url: "{{ route('event.gallery.upload', $event) }}",
            thumbnailWidth: null,
            thumbnailHeight: null,
            previewsContainer: $dropzonePreview.get(0),
            previewTemplate: $dropzonePreview.html(),
            autoProcessQueue: false,
            parallelUploads: 1,
            maxFiles: 50,
            maxFilesize: {{ config('app.max_file_size') / 1024 }},
            acceptedFiles: ".png,.jpeg,.jpg,.mp4,.mov",
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
            },
            init: function () {
                const objDropzone = this;

                let totalFiles = 0;

                objDropzone.on("success", function (file, response) {
                    if (file.previewElement) {
                        $(file.previewElement).find("[data-dz-successmessage]").text(response);
                        $(file.previewElement).find("[data-dz-remove]").remove();
                        totalFiles++;
                    }
                });

                objDropzone.on("complete", function (file) {
                    if (file.previewElement) {
                        $(file.previewElement).find(".progress").remove();
                    }

                    objDropzone.processQueue();
                });

                objDropzone.on("queuecomplete", function () {
                    alert(`Total ${totalFiles} item(s) are successfully uploaded.`);
                    totalFiles = 0;
                    resetSubmitButton();
                    window.location.reload();
                });

                $("#eventPhotosUpload").on("submit", function (ev) {
                    ev.preventDefault();

                    if (objDropzone.getQueuedFiles().length) {
                        objDropzone.processQueue();
                    } else {
                        resetSubmitButton();
                    }
                });
            },
        });

        $dropzonePreview.html("");

        function resetSubmitButton() {
            $("#eventPhotosUpload").find("button[type=submit]")
                        .prop("disabled", false)
                        .html('<i class="fas fa-upload mr-2"></i>{{ __('Confirmed & Upload') }}');
        }
    </script>
@endpush
