<div class="card">
    @component('admin.components.filter')
        @slot('status', null)

            <div class="px-3 py-2">
                <label class="form-control-label" for="filterType">{{ __('Filter Type') }}</label>
                <select class="form-control" name="type" id="filterType" data-toggle="select">
                    <option value="all">{{ __('All') }}</option>
                    @foreach (['image' => __('Photo'), 'video' => __('Video')] as $key => $label)
                        <option value="{{ $key }}" @selected(request()->query('type') == $key)>{{ $label }}</option>
                    @endforeach
                </select>
            </div>
    @endcomponent

    <div class="py-4">
        <table id="tableEventGallery" class="table align-items-center table-flush" width="100%">
            <thead class="thead-light">
                <tr>
                    <th>#</th>
                    <th>{{ __('Actions') }}</th>
                    <th>{{ __('Thumbnail') }}</th>
                    <th>{{ __('File') }}</th>
                    <th>{{ __('Type') }}</th>
                    <th>{{ __('Size') }}</th>
                    <th>{{ __('Created At') }}</th>
                    <th>{{ __('Updated At') }}</th>
                </tr>
            </thead>
        </table>
    </div>
</div>

@include('admin.datatables.table', [
    'name' => 'EventGallery',
    'route' => route('event.gallery.index', $event),
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false),
        get_dt_column_config('thumbnail', orderable: false, searchable: false),
        get_dt_column_config('file', 'name'),
        get_dt_column_config('type', 'mime', searchable: false),
        get_dt_column_config('size', searchable: false),
        get_dt_column_config('created_at', searchable: false),
        get_dt_column_config('updated_at', searchable: false),
    ]
])

@push('js')
    <script nonce="{{ csp_nonce('script') }}">
        $("#filterType").on('change', function (ev) {
            const urlParams = new URLSearchParams(window.location.search);

            if ($(this).val() != 'all') {
                urlParams.set('type', $(this).val());
            } else {
                urlParams.delete('type');
            }

            window.location.search = urlParams;
        });
    </script>
@endpush
