@extends('admin.layouts.base', [
    'title' => __(':event Gallery', ['event' => $event->title]),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-photo-film fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('event.index') }}">{{ __('Events') }}</a></li>
        <li class="breadcrumb-item"><a href="{{ route('event.edit', $event) }}">{{ $event->title }}</a></li>
        <li class="breadcrumb-item text-white active" aria-current="page">{{ __('Gallery') }}</li>

        @slot('buttons')
            <a href="{{ route('event.edit', $event) }}" class="btn btn-sm btn-neutral">
                <i class="fas fa-edit mr-2"></i>
                {{ __('Edit') }}
            </a>
        @endslot
    @endcomponent
@endsection

@section('content')
    <div class="container-fluid mt--8">
        @include('event::admin.gallery.table')
        @include('event::admin.gallery.uploader')
    </div>
@endsection



