@extends('admin.layouts.base', [
    'title' => __('Edit :event Gallery', ['event' => $event->title]),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-photo-film fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('event.index') }}">{{ __('Events') }}</a></li>
        <li class="breadcrumb-item"><a href="{{ route('event.edit', $event) }}">{{ $event->title }}</a></li>
        <li class="breadcrumb-item"><a href="{{ route('event.gallery.index', $event) }}">{{ __('Gallery') }}</a></li>
        <li class="breadcrumb-item text-white active" aria-current="page">{{ __('Edit') }}</li>

        @slot('buttons')
            <a href="{{ route('event.gallery.index', $event) }}" class="btn btn-sm btn-neutral">
                <i class="fas fa-photo-film mr-2"></i>
                {{ __('Gallery: :count', ['count' => $event->photos()->count()]) }}
            </a>
        @endslot
    @endcomponent
@endsection

@section('content')
    <div class="container-fluid mt--8">
        <div class="row">
            <div class="col-xl-12 order-xl-1">
                @component('admin.components.form')
                    @slot('edit', true)
                    @slot('title', __('Edit Event Gallery') . ' #' . $photo->id)
                    @slot('route', route('event.gallery.update', [$event, $photo]))

                    @include('event::admin.gallery.form', ['edit' => true])
                @endcomponent
            </div>
        </div>
    </div>
@endsection

@push('css')
@endpush

@push('vendor-js')
@endpush

@push('js')
@endpush
