<div class="col-12 form-group">
    <label class="form-control-label" for="input-title">{{ __('Title') }} <sup class="text-danger">*</sup></label>
    <div class="{{ $errors->has('title') ? 'has-danger' : '' }}">
        <input type="text" name="title" id="input-title"
            class="form-control {{ $errors->has('title') ? 'is-invalid' : '' }}" maxlength="100"
            placeholder="{{ __('Title') }}" value="{{ old('title', $event->title) }}" required>
    </div>
    @include('alerts.feedback', ['field' => 'title'])
</div>

<div class="col-12 form-group">
    <label class="form-control-label" for="input-location">{{ __('Location') }} <sup class="text-danger">*</sup></label>
    <div class="{{ $errors->has('location') ? 'has-danger' : '' }}">
        <input type="text" name="location" id="input-location"
            class="form-control {{ $errors->has('location') ? 'is-invalid' : '' }}" maxlength="100"
            placeholder="{{ __('Location') }}" value="{{ old('location', $event->location) }}" required>
    </div>
    @include('alerts.feedback', ['field' => 'location'])
</div>

<div class="col-12 form-group">
    <label class="form-control-label" for="input-timezone">{{ __('Timezone') }}</label>
    <div class="{{ $errors->has('timezone') ? 'has-danger' : '' }}">
        <input type="text" name="timezone" id="input-timezone"
            class="form-control {{ $errors->has('timezone') ? 'is-invalid' : '' }}" maxlength="100"
            placeholder="{{ __('Timezone') }}" value="{{ old('timezone', $event->timezone) }}">
    </div>
    @include('alerts.feedback', ['field' => 'timezone'])
</div>

<div class="col-12 form-group">
    <label class="form-control-label" for="input-speakers">{{ __('Speakers') }}</label>
    <select name="speakers[]" id="input-speakers"
        class="form-control {{ $errors->has('speakers') ? 'is-invalid' : '' }}"
        placeholder="{{ __('Please Select Speaker') }}" data-toggle="select" multiple>
        <option value="">{{ __('Please Select Speaker') }}</option>
        @foreach ($speakers as $id => $name)
            <option value="{{ $id }}" @selected(in_array($id, old('speakers', $event->exists ? $event->speakers()->pluck('id')->toArray() : [])))>{{ $name }}</option>
        @endforeach
    </select>
    @include('alerts.feedback', ['field' => 'speakers'])
</div>

<div class="col-12 form-group">
    <label class="form-control-label" for="input-relatedEvents">{{ __('Related Events') }}</label>
    <select name="related_events[]" id="input-relatedEvents"
        class="form-control {{ $errors->has('related_events') ? 'is-invalid' : '' }}"
        placeholder="{{ __('Please Select Related Events') }}" data-toggle="select" multiple>
        <option value="">{{ __('Please Select Related Events') }}</option>
        @foreach ($events as $id => $name)
            @if ($id !== $event->id)
                <option value="{{ $id }}" @selected(in_array($id, old('related_events', $event->exists ? $event->relatedEvents()->pluck('related_event_id')->toArray() : [])))>{{ $name }}</option>
            @endif
        @endforeach
    </select>
    @include('alerts.feedback', ['field' => 'related_events'])
</div>

<div class="col-md-6 form-group">
    <label class="form-control-label" for="input-start_date">{{ __('Start Date') }} <sup
            class="text-danger">*</sup></label>
    <div class="{{ $errors->has('start_date') ? 'has-danger' : '' }}">
        <input type="date" name="start_date" id="input-start_date"
            class="flatpickr-start form-control {{ $errors->has('start_date') ? 'is-invalid' : '' }}"
            placeholder="{{ __('Start Date') }}" value="{{ old('start_date', $event->start_date?->format('Y-m-d')) }}"
            required>
    </div>
    @include('alerts.feedback', ['field' => 'start_date'])
</div>

<div class="col-md-6 form-group">
    <label class="form-control-label" for="input-end_date">{{ __('End Date') }}</label>
    <div class="{{ $errors->has('end_date') ? 'has-danger' : '' }}">
        <input type="date" name="end_date" id="input-end_date"
            class="flatpickr-end form-control {{ $errors->has('end_date') ? 'is-invalid' : '' }}"
            placeholder="{{ __('End Date') }}" value="{{ old('end_date', $event->end_date?->format('Y-m-d')) }}">
    </div>
    @include('alerts.feedback', ['field' => 'end_date'])
</div>

{{-- @include('admin.components.fileinput', [
    'thumbnail' => [
        'delete' => asset_exists($event->thumbnail),
        'label' => 'thumbnail',
        'url' => $event->thumbnail_path,
        'path' => $event->thumbnail,
        'policy' => 'update',
        'entity' => $event::class,
        'hash' => $event->hash_id,
    ],
    'label' => 'Thumbnail',
    'name' => 'thumbnail',
]) --}}

@include('admin.components.fileinput', [
    'thumbnail' => [
        // 'delete' => asset_exists($event->banner),
        'label' => 'banner',
        'url' => $event->banner_path,
        'path' => $event->banner,
        'policy' => 'update',
        'entity' => $event::class,
        'hash' => $event->hash_id,
    ],
    'label' => 'Banner',
    'name' => 'banner',
    'recommend' => '300px * 300px',
    'required' => !$event->exists,
    'uploaded' =>
        $event->exists && $event->banner_path ? ['url' => $event->banner_path, 'path' => $event->banner] : [],
])

@include('admin.components.fileinput', [
    'thumbnail' => $event->file_path
        ? [
            'delete' => asset_exists($event->file_path),
            'label' => 'Schedule PDF',
            'column' => 'file_path',
            'url' => $event->file_thumbnail_url,
            'path' => $event->file_path,
            'policy' => 'update',
            'entity' => $event::class,
            'hash' => $event->hash_id,
            'padding' => true,
        ]
        : [],
    'required' => false,
    'label' => 'Schedule PDF',
    'name' => 'file',
    'mimes' => 'PDF',
    'uploaded' =>
        $event->exists && $event->file_path ? ['url' => $event->file_url, 'path' => $event->file_name] : [],
])

@include('admin.components.tinymce', ['editors' => ['Description*' => 'description'], 'model' => $event])

<div class="col-12 form-group d-flex align-items-center">
    <label class="form-control-label mb-0 mr-3">{{ __('Featured') }} <sup class="text-danger">*</sup></label>
    <label class="custom-toggle">
        <input type="checkbox" name="is_featured" value="1"
            {{ old('is_featured', $event->is_featured) ? 'checked' : '' }}>
        <span class="custom-toggle-slider rounded-circle" data-label-off="No" data-label-on="Yes"></span>
    </label>
</div>

<div class="col-12 form-group d-flex align-items-center">
    <label class="form-control-label mb-0 mr-3">{{ __('Enable Submit Feedback') }} <sup class="text-danger">*</sup></label>
    <label class="custom-toggle">
        <input type="checkbox" name="enable_submit_feedback" value="1"
            {{ old('enable_submit_feedback', $event->enable_submit_feedback) ? 'checked' : '' }}>
        <span class="custom-toggle-slider rounded-circle" data-label-off="No" data-label-on="Yes"></span>
    </label>
</div>

<div class="col-12 form-group d-flex align-items-center">
    <label class="form-control-label mb-0 mr-3">{{ __('Status Active') }} <sup class="text-danger">*</sup></label>
    <label class="custom-toggle">
        <input type="checkbox" name="is_active" value="1"
            {{ old('is_active', $event->is_active) ? 'checked' : '' }}>
        <span class="custom-toggle-slider rounded-circle" data-label-off="No" data-label-on="Yes"></span>
    </label>
</div>

@push('vendor-css')
    <link rel="stylesheet" href="{{ basset_url('argon/vendor/select2/dist/css/select2.min.css') }}"
        nonce="{{ csp_nonce('style') }}">
    <link rel="stylesheet" href="{{ basset_url('argon/vendor/flatpickr/flatpickr.min.css') }}"
        nonce="{{ csp_nonce('style') }}">
@endpush

@push('vendor-js')
    <script src="{{ basset_url('argon/vendor/select2/dist/js/select2.full.min.js') }}" nonce="{{ csp_nonce('script') }}">
    </script>
    <script src="{{ basset_url('argon/vendor/flatpickr/flatpickr.min.js') }}" nonce="{{ csp_nonce('script') }}"></script>
@endpush

@push('js')
    <script nonce="{{ csp_nonce('script') }}">
        const flatpikrStart = $('.flatpickr-start').flatpickr({
            //
        });

        const flatpikrEnd = $('.flatpickr-end').flatpickr({
            //
        });

        flatpikrStart.config.onChange.push(function(selectedDates, dateStr, instance) {
            if (dateStr) {
                flatpikrEnd.set('minDate', dateStr);
                flatpikrEnd.jumpToDate(dateStr);
            }
        });

        flatpikrEnd.config.onChange.push(function(selectedDates, dateStr, instance) {
            if (dateStr) {
                //
            }
        });
    </script>
@endpush
