@inject('participant', Modules\Participant\Entities\Participant::class)
@inject('feedback', Modules\Feedback\Entities\Feedback::class)

@extends('admin.layouts.base', [
    'title' => __('Edit Event'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-calendar-day fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('event.index') }}">{{ __('Events') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('Edit') }}</li>

        @slot('buttons')
            <a href="{{ route('event.schedule.index', $event) }}" class="btn btn-sm btn-tertiary text-dark">
                <i class="fas fa-clock mr-2"></i>
                {{ __('Schedule: :count', ['count' => $event->schedules()->count()]) }}
            </a>

            <a href="{{ route('event.gallery.index', $event) }}" class="btn btn-sm btn-tertiary text-dark">
                <i class="fas fa-photo-film mr-2"></i>
                {{ __('Gallery: :count', ['count' => $event->photos()->count()]) }}
            </a>

            @can('view-any', $participant)
                <a href="{{ route('participant.index', ['event' => $event->id]) }}" class="btn btn-sm btn-tertiary text-dark">
                    <i class="fas fa-user-group mr-2"></i>
                    {{ __('Participants: :count', ['count' => $event->participants()->count()]) }}
                </a>
            @endcan

            @can('view-any', $feedback)
                <a href="{{ route('feedback.index', ['event' => $event->id]) }}" class="btn btn-sm btn-tertiary text-dark">
                    <i class="fas fa-comments mr-2"></i>
                    {{ __('Feedbacks: :count', ['count' => $event->feedbacks()->count()]) }}
                </a>
            @endcan

            <a href="{{ route('event.index') }}" class="btn btn-sm btn-neutral">{{ __('List All') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
    <div class="container-fluid mt--8">
        <div class="row">
            <div class="col-xl-12 order-xl-1">
                @component('admin.components.form')
                    @slot('edit', true)
                    @slot('title', __('Edit Event') . ' #' . $event->id)
                    @slot('route', route('event.update', $event->hash_id))

                    @include('event::admin.form', ['event' => $event, 'edit' => true])
                @endcomponent
            </div>
        </div>
    </div>
@endsection

@push('css')
@endpush

@push('vendor-js')
@endpush

@push('js')
@endpush
