<?php

namespace Modules\Event\Policies;

use Modules\Event\Entities\Event;
use Illuminate\Auth\Access\HandlesAuthorization;
use Modules\Admin\Entities\Admin;
use Modules\User\Entities\User;

class EventPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the authenticate user can see the events.
     */
    public function viewAny(Admin|User $auth): bool
    {
        return $auth->hasPermission('event');
    }

    /**
     * Determine whether the authenticate user can create events.
     */
    public function create(Admin|User $auth): bool
    {
        return $auth->hasPermission('event');
    }

    /**
     * Determine whether the authenticate user can update the event.
     */
    public function update(Admin|User $auth, Event $model = null): bool
    {
        return $auth->hasPermission('event');
    }

    /**
     * Determine whether the authenticate user can delete the event.
     */
    public function delete(Admin|User $auth, Event $model): bool
    {
        return $auth->hasPermission('event');
    }

    /**
     * Determine whether the admin can restore the item.
     */
    public function restore(Admin|User $auth): bool
    {
        return $auth->hasPermission('event');
    }

    /**
     * Determine whether the admin can export the events.
     */
    public function export(Admin|User $auth): bool
    {
        return false;
    }
}
