<?php

namespace Modules\Event\Http\Requests;

use Modules\Event\Entities\Event;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class EventRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return (bool) admin();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $event = $this->route()->event;

        return [
            'title' => ['required', 'string', 'max:100'],
            'location' => ['required', 'string', 'max:100'],
            'timezone' => ['nullable', 'string', 'max:100'],
            'speakers' => ['nullable', 'array', 'min:1'],
            'speakers.*' => [Rule::exists('speakers', 'id')->where('is_active', 1)],
            'start_date' => ['required', 'date'],
            'end_date' => ['nullable', 'date', 'after_or_equal:start_date'],
            // 'thumbnail' => file_validation($this->get('thumbnail')),
            'banner' => file_validation($this->get('banner'), required: is_null($event), sometimes: false),
            'file' => file_validation($this->get('file'), mimes: 'pdf'),
            'description' => ['required', 'string'],
            'is_featured' => ['sometimes', 'boolean'],
            'is_active' => ['sometimes', 'boolean'],
            'enable_submit_feedback' => ['sometimes', 'boolean'],
        ];
    }

    /**
     * Get the validation attributes that apply to the request.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'file' => 'schedule pdf',
            'is_featured' => 'featured',
            'is_active' => 'status active',
        ];
    }
}
