<?php

namespace Modules\Event\Http\Controllers\Api;

use App\Http\Controllers\Api\ApiController;
use Illuminate\Http\Request;
use Modules\Event\Entities\Event;
use Modules\Event\Transformers\EventCollection;

class UpcomingEventsController extends ApiController
{
    /**
     * Handle the incoming request.
     */
    public function __invoke(Request $request)
    {
        $events = Event::query()
            ->api()
            ->active()
            ->whereAfterToday('start_date')
            ->where(function ($q) {
                $q->whereFuture('end_date');
                $q->orWhereNull('end_date');
            })
            ->filters($request)
            // ->take(config('api.limit_results_per_request', 100))
            ->orderBy('start_date')
            ->orderBy('title')
            ->get();

        return $this->json((new EventCollection($events))->toArray($request));
    }
}
