<?php

namespace Modules\Event\Http\Controllers\Api;

use App\Http\Controllers\Api\ApiController;
use Illuminate\Http\Request;
use Modules\Event\Entities\Event;
use Modules\Event\Transformers\EventResource;
use Symfony\Component\HttpFoundation\Response;

class ReloadEventController extends ApiController
{
    /**
     * Handle the incoming request.
     */
    public function __invoke(Request $request, $hash)
    {
        $event = Event::query()
            ->where('id', Event::keyFromHashId($hash))
            ->api()
            ->active()
            ->first();

        if (!$event) {
            return $this->jsonError(Response::HTTP_NOT_FOUND, __('Event not found or inactive.'), reference_code: 'E001');
        }

        return $this->json((new EventResource($event))->toArray($request));
    }
}
