<?php

namespace Modules\Event\Http\Controllers\Api;

use App\Http\Controllers\Api\ApiController;
use Illuminate\Http\Request;
use Modules\Event\Entities\Event;
use Modules\Event\Transformers\EventCollection;

class AllEventsController extends ApiController
{
    /**
     * Handle the incoming request.
     */
    public function __invoke(Request $request)
    {
        $events = Event::query()
            ->api()
            ->active()
            ->featured()
            ->filters($request)
            // ->take(config('api.limit_results_per_request', 100))
            ->latest('start_date')
            ->orderBy('title')
            ->get();

        return $this->json((new EventCollection($events))->toArray($request), extra: [
            'hidden' => ['all'],
            'years' => $events->pluck('start_date')->map(fn ($date) => $date->format('Y'))->unique()->sort()->values()->toArray(),
        ]);
    }
}
