<?php

namespace Modules\Event\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Model>
 */
class EventPhotoFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = \Modules\Event\Entities\EventPhoto::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        $extension = fake()->randomElement(['jpg', 'mov', 'mp4', 'png']);

        return [
            // 'position' => 0,
            'path' => $path = 'files/sample/sample.' . $extension,
            'name' => $name = str(fake()->words(asText: true))->slug() . '.' . $extension,
            'extension' => $extension,
            'mime' => disk_public()->mimeType($path),
            'size' => disk_public()->size($path),
            'created_by' => 1,
        ];
    }
}
