<?php

use Illuminate\Support\Facades\Route;
use Modules\Country\Http\Controllers\AdminController;

Route::prefix('country')->name('country.')->group(function () {
    Route::controller(AdminController::class)->group(function () {
        Route::get('/', 'index')->name('index');

        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');

        Route::get('{country}/edit', 'edit')->name('edit');
        Route::put('{country}', 'update')->name('update');

        Route::delete('{country}', 'destroy')->name('destroy');

        Route::get('trashed', 'trashed')->name('trashed');
        Route::post('restore/{id}', 'restore')->name('restore');

        Route::get('export', 'export')->name('export');
    });
});