
@inject('country', Modules\Country\Entities\Country::class)

@extends('admin.layouts.base', [
    'title' => __('Countries Trashed'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-earth-americas fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('country.index') }}">{{ __('Countries') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('Trashed') }}</li>

        @slot('buttons')
            <a href="{{ route('country.index') }}" class="btn btn-sm btn-neutral">{{ __('List All') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
<div class="container-fluid mt--8">
    <div class="card">
        <div class="py-4">
            <table id="tableCountry" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        @canany(['restore'], $country)
                            <th>{{ __('Actions') }}</th>
                        @endcanany
                        <th>{{ __('Name') }}</th>
                        <th>{{ __('ISO2') }}</th>
                        <th>{{ __('Region') }}</th>
                        <th>{{ __('Code') }}</th>
                        <th>{{ __('Deleted At') }}</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'Country',
    'route' => route('country.trashed'),
    'orders' => [6, 'desc'],
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $country, can: ['restore']),
        get_dt_column_config('name'),
        get_dt_column_config('iso'),
        get_dt_column_config('region_name'),
        get_dt_column_config('region_code'),
        get_dt_column_config('deleted_at', searchable: false),
    ]
])
