<?php

namespace Modules\Country\Policies;

use Modules\Country\Entities\Country;
use Illuminate\Auth\Access\HandlesAuthorization;
use Modules\Admin\Entities\Admin;
use Modules\User\Entities\User;

class CountryPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the authenticate user can see the countries.
     */
    public function viewAny(Admin|User $auth): bool
    {
        return false;
    }

    /**
     * Determine whether the authenticate user can create countries.
     */
    public function create(Admin|User $auth): bool
    {
        return false;
    }

    /**
     * Determine whether the authenticate user can update the country.
     */
    public function update(Admin|User $auth, Country $model): bool
    {
        return false;
    }

    /**
     * Determine whether the authenticate user can delete the country.
     */
    public function delete(Admin|User $auth, Country $model): bool
    {
        return false;
    }

    /**
     * Determine whether the admin can restore the item.
     */
    public function restore(Admin|User $auth): bool
    {
        return false;
    }

    /**
     * Determine whether the admin can export the countries.
     */
    public function export(Admin|User $auth): bool
    {
        return false;
    }
}
