<?php

use Illuminate\Support\Facades\Route;
use Modules\Category\Http\Controllers\AdminController;

Route::prefix('category')->name('category.')->group(function () {
    Route::controller(AdminController::class)->group(function () {
        Route::get('/', 'index')->name('index');

        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');
        Route::post('reorder', 'reorder')->name('reorder');

        Route::get('{category}/edit', 'edit')->name('edit');
        Route::put('{category}', 'update')->name('update');

        Route::delete('{category}', 'destroy')->name('destroy');

        Route::get('trashed', 'trashed')->name('trashed');
        Route::post('restore/{id}', 'restore')->name('restore');

        Route::get('export', 'export')->name('export');
    });
});
