
@inject('category', Modules\Category\Entities\Category::class)

@extends('admin.layouts.base', [
    'title' => __('Categories Trashed'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-boxes fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('category.index') }}">{{ __('Categories') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('Trashed') }}</li>

        @slot('buttons')
            <a href="{{ route('category.index') }}" class="btn btn-sm btn-neutral">{{ __('List All') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
<div class="container-fluid mt--8">
    <div class="card">
        <div class="py-4">
            <table id="tableCategory" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        @canany(['restore'], $category)
                            <th>{{ __('Actions') }}</th>
                        @endcanany
                        <th>{{ __('Name') }}</th>
                        <th>{{ __('Keywords') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Deleted At') }}</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'Category',
    'route' => route('category.trashed'),
    'orders' => [5, 'desc'],
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $category, can: ['restore']),
        get_dt_column_config('name'),
        get_dt_column_config('keywords'),
        get_dt_column_config('status', 'is_active', searchable: false),
        get_dt_column_config('deleted_at', searchable: false),
    ]
])
