@inject('category', Modules\Category\Entities\Category::class)

@extends('admin.layouts.base', [
    'title' => __('Categories Management'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-boxes fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('category.index') }}">{{ __('Categories') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('List All') }}</li>

        @slot('buttons')
            @can('create', $category)
                <a href="{{ route('category.create') }}" class="btn btn-sm btn-neutral">{{ __('Create New') }}</a>
            @endcan

            @can('export', $category)
                <a href="{{ route('category.export', request()->query()) }}" class="btn btn-sm btn-primary">{{ __('Export Excel') }}</a>
            @endcan
        @endslot
    @endcomponent
@endsection

@section('content')
    @include('category::admin.components.lists')
@endsection
