
@inject('category', Modules\Category\Entities\Category::class)

@extends('admin.layouts.base', [
    'title' => __('Categories Management'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-boxes fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('category.index') }}">{{ __('Categories') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('List All') }}</li>

        @slot('buttons')
            @can('create', $category)
                <a href="{{ route('category.create') }}" class="btn btn-sm btn-neutral">{{ __('Create New') }}</a>
            @endcan

            @can('export', $category)
                <a href="{{ route('category.export', request()->query()) }}" class="btn btn-sm btn-primary">{{ __('Export Excel') }}</a>
            @endcan
        @endslot
    @endcomponent
@endsection

@section('content')
<div class="container-fluid mt--8">
    <div class="card">
        @component('admin.components.filter')
            @slot('status', true)

            {{-- <div class="px-3 py-2">
                <label class="form-control-label" for="filterGroup">{{ __('Filter Group') }}</label>
                <select class="form-control" name="group" id="filterGroup" data-toggle="select">
                    <option value="all">{{ __('All') }}</option>
                    @foreach ($groups as $id => $name)
                        <option value="{{ $id }}" @selected(request()->query('group') == $id)>{{ $name }}</option>
                    @endforeach
                </select>
            </div> --}}
        @endcomponent

        <div class="py-4">
            <table id="tableCategory" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        @canany(['update', 'delete'], $category)
                            <th>{{ __('Actions') }}</th>
                        @endcanany
                        <th>{{ __('Name') }}</th>
                        <th>{{ __('Keywords') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Created At') }}</th>
                        <th>{{ __('Updated At') }}</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'Category',
    'route' => route('category.index'),
    'orders' => [5, 'desc'],
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $category, can: ['update', 'delete']),
        get_dt_column_config('name'),
        get_dt_column_config('keywords'),
        get_dt_column_config('status', 'is_active', searchable: false),
        get_dt_column_config('created_at', searchable: false),
        get_dt_column_config('updated_at', searchable: false),
    ]
])

@push('js')
    {{-- <script nonce="{{ csp_nonce('script') }}">
        $("#filterGroup").on('change', function (ev) {
            const urlParams = new URLSearchParams(window.location.search);

            if ($(this).val() != 'all') {
                urlParams.set('group', $(this).val());
            } else {
                urlParams.delete('group');
            }

            window.location.search = urlParams;
        });
    </script> --}}
@endpush
