@extends('admin.layouts.base', [
    'title' => __('Edit Category'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-boxes fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('category.index') }}">{{ __('Categories') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('Edit') }}</li>

        @slot('buttons')
            <a href="{{ route('category.index') }}" class="btn btn-sm btn-neutral">{{ __('List All') }}</a>
            <a href="{{ url()->previous() }}" class="btn btn-sm btn-primary">{{ __('Back') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
    <div class="container-fluid mt--8">
        <div class="row">
            <div class="col-xl-12 order-xl-1">
                @component('admin.components.form')
                    @slot('edit', true)
                    @slot('title', __('Edit Category') . ' #' . $category->id)
                    @slot('route', route('category.update', $category->hash_id))

                    @include('category::admin.form', ['category' => $category, 'edit' => true])
                @endcomponent
            </div>
        </div>
    </div>
@endsection

@push('css')
@endpush

@push('vendor-js')
@endpush

@push('js')
@endpush
