<div class="nested-padding" data-id="{{ $category->id }}">
    <div class="input-group mb-0">
        <div class="input-group-prepend">
            <div class="input-group-text pl-3 pr-0">
                @can('update', $category)
                    <div class="grabbing mr-3" data-placement="right" data-toggle="tooltip" title="Drag">
                        <i class="fas fa-arrows-alt text-primary"></i>
                    </div>

                    <a href="{{ route('category.edit', ['category' => $category, 'redirect' => true]) }}" class="mr-3" data-placement="right" data-toggle="tooltip" title="Edit">
                        <i class="fas fa-edit text-primary"></i>
                    </a>
                @endcan

                @can('delete', $category)
                    <form action="{{ route('category.destroy', $category) }}" class="need-confirm mr-3" method="post">
                        @method('delete')
                        @csrf
                        <button type="submit" class="btn-trash table-action table-action-delete border-0 bg-transparent px-0" data-placement="right" data-toggle="tooltip" title="Delete">
                            <i class="fas fa-trash"></i>
                        </button>
                    </form>
                @endcan
            </div>
        </div>
        <input type="text" class="form-control h-auto" name="name" value="{{ $category->name }}" required>
        <div class="input-group-append">
            <div class="input-group-text align-items-stretch">
                <span class="badge badge-pill badge-info mr-2 py-1" style="line-height: 1rem;" data-placement="right" data-toggle="tooltip" title="Items">{{ $category->entity_count }}</span>
                <label class="custom-toggle" data-placement="right" data-toggle="tooltip" title="Status Active">
                    <input type="checkbox" name="is_active" value="1" {{ $category->is_active ? 'checked' : '' }}>
                    <span class="custom-toggle-slider rounded-circle" data-label-off="No" data-label-on="Yes"></span>
                </label>
            </div>
        </div>
    </div>

    {{-- @if (!$category->parent_id) --}}
        @include('category::admin.components.children', ['category' => $category])
    {{-- @endif --}}
</div>
