@inject('category_entity', Modules\Category\Entities\Category::class)

<div class="container-fluid mt--8">
    <div class="row">
        <div class="col-12 col-md-7">
            @component('admin.components.card')
                @slot('title', __('Categories'))

                @if ($categories->isNotEmpty())
                    <div id="categories-sortable" class="nested-sortable">
                        @foreach ($categories as $category)
                            @include('category::admin.components.row', ['category' => $category, 'first' => true])
                        @endforeach
                    </div>

                    <form method="post" action="{{ route('category.reorder') }}">
                        @csrf
                        <input type="hidden" name="categories" id="input-categories" value="">
                        <div class="text-center mt-4">
                            <button type="submit" id="categories-update" class="btn btn-success" disabled>
                                <i class="fas fa-save mr-2"></i> {{ __('Update') }}
                            </button>
                        </div>
                    </form>
                @else
                    <div class="alert alert-warning mb-0" role="alert">
                        <strong>{{ __('No categories available. Start by adding a new category using the form on the right.') }}</strong>
                    </div>
                @endif
            @endcomponent
        </div>
        <div class="col-12 col-md-5">
            @component('admin.components.form')
                @slot('title', __('New Category'))
                @slot('route', route('category.store'))

                <input type="hidden" name="module" value="{{ $module }}">

                @include('category::admin.form', ['category' => $category_entity])
            @endcomponent
        </div>
    </div>
</div>

@push('css')
    @bassetBlock('admin/css/categories-sortable.css')
        <style>
            .grabbing {
                cursor: grab;
            }
        </style>
    @endBassetBlock()
@endpush

@push('vendor-js')
    <script src="{{ basset_url('https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js') }}" nonce="{{ csp_nonce('script') }}"></script>
@endpush

@push('js')
    @bassetBlock('admin/js/categories-sortable.js')
        <script nonce="{{ basset_nonce('script') }}">
            $(document).ready(function() {
                window.listenFormNeedConfirmation();

                var nestedSortables = document.getElementsByClassName('nested-sortable');

                for (var i = 0; i < nestedSortables.length; i++) {
                    new Sortable(nestedSortables[i], {
                        handle: '.grabbing',
                        group: 'nested',
                        animation: 150,
                        fallbackOnBody: true,
                        swapThreshold: 0.65,
                        onMove(event) {
                            const to = $(event.to);
                            const dragged = $(event.dragged);

                            // NOTE: to limit up to 2nd level menu only
                            const lvl = to.parents('.nested-sortable').length;

                            // NOTE: to block nested when itself have children
                            const children = dragged.find('.nested-padding').length;

                            if (lvl == 0 && children == 0) {
                                return true;
                            } else if (lvl == 0 && children > 1) {
                                return true;
                            @if ($second_level ?? false)
                            } else if (lvl == 1 && children == 0) {
                                to.addClass('pt-2 border border-top-0 border-right-0 bg-lighter rounded-bottom');
                                return true;
                            @endif
                            } else {
                                return false;
                            }
                        },
                        onEnd: handleSortEnd
                    });
                }
            });

            $('#categories-sortable .nested-padding input').on('input', handleSortEnd);

            function handleSortEnd(event) {
                const item = $(event.item);
                const to = $(event.to);
                const from = $(event.from);

                const children = item.find('.nested-padding').length;

                if (children == 0) {
                    // main first level
                    if (to.attr('id') == 'categories-sortable') {
                        item.find('.nested-sortable').removeClass('mb-2').addClass('mb-3')
                    } else {
                        item.find('.nested-sortable').addClass('mb-2').removeClass('mb-3')
                    }
                }

                var arraySortable = [];
                var categoriesSortable = $('#categories-sortable');
                var categoriesSortableCount = categoriesSortable.find('.nested-padding').length;

                var findChild = function(index, item, parent) {
                    if (arraySortable.length == categoriesSortableCount) {
                        return;
                    }

                    if (item) {
                        var id = $(item).data('id');

                        arraySortable.push({
                            parent_id: parent,
                            position: arraySortable.length,
                            id,
                            name: $(item).find('input[name=name]').first().val(),
                            is_active: $(item).find('input[name=is_active]').first().is(':checked'),
                        });

                        const wrapper = $(item).find('.nested-sortable');

                        if (parent == 0) {
                            if (wrapper.find('.nested-padding').length == 0) {
                                wrapper.removeClass('pt-2 border border-top-0 border-right-0 bg-lighter rounded-bottom')
                            }
                        }

                        wrapper.children('.nested-padding').each(function(index, item) {
                            findChild(index, item, id);
                        });
                    }
                }

                categoriesSortable.children('.nested-padding').each(function(index, item) {
                    findChild(index, item, 0);
                });

                if (arraySortable.length) {
                    $('#input-categories').val(JSON.stringify(arraySortable));
                    $('#categories-update').prop('disabled', false);
                } else {
                    $('#input-categories').val('');
                    $('#categories-update').prop('disabled', true);
                }
            }
        </script>
    @endBassetBlock()
@endpush
