<?php

namespace Modules\Category\Policies;

use Modules\Category\Entities\Category;
use Illuminate\Auth\Access\HandlesAuthorization;
use Modules\Admin\Entities\Admin;
use Modules\User\Entities\User;

class CategoryPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the authenticate user can see the categories.
     */
    public function viewAny(Admin|User $auth): bool
    {
        return false;
    }

    /**
     * Determine whether the authenticate user can create categories.
     */
    public function create(Admin|User $auth): bool
    {
        return true;
    }

    /**
     * Determine whether the authenticate user can update the category.
     */
    public function update(Admin|User $auth, Category $model = null): bool
    {
        return true;
    }

    /**
     * Determine whether the authenticate user can delete the category.
     */
    public function delete(Admin|User $auth, Category $model): bool
    {
        return true;
    }

    /**
     * Determine whether the admin can restore the item.
     */
    public function restore(Admin|User $auth): bool
    {
        return false;
    }

    /**
     * Determine whether the admin can export the categories.
     */
    public function export(Admin|User $auth): bool
    {
        return false;
    }
}
