<?php

namespace Modules\Category\Http\Requests;

use Modules\Category\Entities\Category;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class CategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return (bool) admin();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $category = $this->route()->category;

        return [
            // 'parent_id' => ['sometimes', 'nullable', Rule::exists('categories', 'id')],
            'name' => ['required', 'string', 'max:200'],
            // 'slug' => ['required', 'alpha_dash', Rule::unique((new Category())->getTable())->ignore($category)],
            'description' => ['nullable', 'string'],
            // 'keywords' => ['nullable', 'string'],
            'is_active' => ['sometimes', 'boolean'],
        ];
    }

    /**
     * Get the validation attributes that apply to the request.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            // 'parent_id' => 'group',
            'keywords' => 'keywords',
            'is_active' => 'status',
        ];
    }
}
