<?php

namespace Modules\Category\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Category\Entities\Category;
use Modules\Document\Entities\Document;
use Modules\Marketing\Entities\Marketing;
use Modules\Training\Entities\Training;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Model>
 */
class CategoryFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = \Modules\Category\Entities\Category::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            // 'parent_id',
            // 'entity_type',
            // 'entity_id',
            // 'position' => fake()->unique()->numberBetween(1, 50),
            'name' => $name = fake()->words(3, true),
            // 'slug' => str($name)->slug(),
            'description' => fake()->sentence(),
            'keywords' => implode(', ', fake()->words(6)),
            'is_active' => fake()->boolean(90),
            'created_by' => 1,
        ];
    }

    public function typeMarketing(): static
    {
        return $this->state(fn (array $attributes) => [
            'entity_type' => Marketing::class,
        ]);
    }

    public function typeDocument(): static
    {
        return $this->state(fn (array $attributes) => [
            'entity_type' => Document::class,
        ]);
    }

    public function typeTraining(): static
    {
        return $this->state(fn (array $attributes) => [
            'entity_type' => Training::class,
        ]);
    }

    public function mayHaveChildren($min, $max): static
    {
        return $this->afterCreating(function (Category $category) use ($min, $max) {
            if ($have_children = fake()->boolean(60)) {
                Category::factory(fake()->numberBetween($min, $max))
                    ->when($category->entity_type == Marketing::class, function ($f) use ($min, $max) {
                        return $f->has(Marketing::factory(fake()->numberBetween($min, $max)), 'marketings');
                    })
                    ->when($category->entity_type == Document::class, function ($f) use ($min, $max) {
                        return $f->has(Document::factory(fake()->numberBetween($min, $max)), 'documents');
                    })
                    ->when($category->entity_type == Training::class, function ($f) use ($min, $max) {
                        return $f->has(Training::factory(fake()->numberBetween($min, $max)), 'trainings');
                    })
                    ->createQuietly([
                        'parent_id' => $category->id,
                        'entity_type' => $category->entity_type,
                    ]);
            }
        });
    }
}
