<?php

use Illuminate\Support\Facades\Route;
use Modules\Block\Http\Controllers\AdminController;

Route::prefix('block')->name('block.')->group(function () {
    Route::controller(AdminController::class)->group(function () {
        Route::get('/', 'index')->name('index');

        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');

        Route::get('{block}/edit', 'edit')->name('edit');
        Route::put('{block}', 'update')->name('update');

        Route::delete('{block}', 'destroy')->name('destroy');

        Route::get('trashed', 'trashed')->name('trashed');
        Route::post('restore/{id}', 'restore')->name('restore');

        Route::get('export', 'export')->name('export');
    });
});
