
@inject('block', Modules\Block\Entities\Block::class)

@extends('admin.layouts.base', [
    'title' => __('Blocks Trashed'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-shapes fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('block.index') }}">{{ __('Blocks') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('Trashed') }}</li>

        @slot('buttons')
            <a href="{{ route('block.index') }}" class="btn btn-sm btn-neutral">{{ __('List All') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
<div class="container-fluid mt--8">
    <div class="card">
        <div class="py-4">
            <table id="tableBlock" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        @canany(['restore'], $block)
                            <th>{{ __('Actions') }}</th>
                        @endcanany
                        <th>{{ __('Title') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Deleted At') }}</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'Block',
    'route' => route('block.trashed'),
    'orders' => [4, 'desc'],
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $block, can: ['restore']),
        get_dt_column_config('title'),
        get_dt_column_config('status', 'is_active', searchable: false),
        get_dt_column_config('deleted_at', searchable: false),
    ]
])
