
@inject('block', Modules\Block\Entities\Block::class)

@extends('admin.layouts.base', [
    'title' => __('Blocks Management'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-shapes fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('block.index') }}">{{ __('Blocks') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('List All') }}</li>

        @slot('buttons')
            @can('create', $block)
                <a href="{{ route('block.create') }}" class="btn btn-sm btn-neutral">{{ __('Create New') }}</a>
            @endcan

            @can('export', $block)
                <a href="{{ route('block.export', request()->query()) }}" class="btn btn-sm btn-primary">{{ __('Export Excel') }}</a>
            @endcan
        @endslot
    @endcomponent
@endsection

@section('content')
<div class="position-relative container-fluid mt--8">
    <div class="card">
        @component('admin.components.filter')
            @slot('status', null)
        @endcomponent

        <div class="py-4">
            <table id="tableBlock" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        @canany(['update', 'delete'], $block)
                            <th>{{ __('Actions') }}</th>
                        @endcanany
                        <th>{{ __('Title') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Created At') }}</th>
                        <th>{{ __('Updated At') }}</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'Block',
    'route' => route('block.index'),
    'orders' => [4, 'desc'],
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $block, can: ['update', 'delete']),
        get_dt_column_config('title'),
        get_dt_column_config('status', 'is_active', searchable: false),
        get_dt_column_config('created_at', searchable: false),
        get_dt_column_config('updated_at', searchable: false),
    ]
])
