<input type="hidden" name="k" value="{{ request()->query('k') }}">

<div class="col-md form-group">
    <label class="form-control-label" for="input-title">{{ __('Title') }} <sup class="text-danger">*</sup></label>
    <div class="{{ $errors->has('title') ? 'has-danger' : '' }}">
        <input type="text" name="title" id="input-title" class="form-control {{ $errors->has('title') ? 'is-invalid' : '' }}" placeholder="{{ __('Title') }}" value="{{ old('title', $block->title) }}" autofocus required>
    </div>
    @include('alerts.feedback', ['field' => 'title'])
</div>

<div class="col-12 px-0">
    @include('admin.components.tinymce', ['editors' => ['Content*' => 'editor_content'], 'model' => $block])
</div>

<div class="col-12 form-group d-flex align-items-center">
    <label class="form-control-label mb-0 mr-3">{{ __('Status Active') }} <sup class="text-danger">*</sup></label>
    <label class="custom-toggle">
        <input type="checkbox" name="is_active" value="1" {{ old('is_active', $block->is_active) ? 'checked' : '' }}>
        <span class="custom-toggle-slider rounded-circle" data-label-off="No" data-label-on="Yes"></span>
    </label>
</div>
