@extends('admin.layouts.base', [
    'title' => __('Edit Block'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-shapes fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('block.index') }}">{{ __('Blocks') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('Edit') }}</li>

        @slot('buttons')
            <a href="{{ route('block.index') }}" class="btn btn-sm btn-neutral">{{ __('List All') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
    <div class="container-fluid mt--8">
        <div class="row">
            <div class="col-xl-12 order-xl-1">
                @component('admin.components.form')
                    @slot('edit', true)
                    @slot('title', __('Edit Block') . ' #' . $block->id)
                    @slot('route', route('block.update', $block->hash_id))

                    @include('block::form', ['block' => $block, 'edit' => true])
                @endcomponent
            </div>
        </div>
    </div>
@endsection

@push('css')
@endpush

@push('vendor-js')
@endpush

@push('js')
@endpush
