<?php

namespace Modules\Block\Policies;

use Modules\Block\Entities\Block;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Support\Facades\Hash;
use Modules\Admin\Entities\Admin;

class BlockPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the block can see the blocks.
     *
     * @param  \Modules\Admin\Entities\Admin $admin
     * @return boolean
     */
    public function viewAny(Admin $admin)
    {
        return $admin->hasPermission('block');
    }

    /**
     * Determine whether the authenticate user can create blocks.
     *
     * @param  \Modules\Admin\Entities\Admin $admin
     * @return boolean
     */
    public function create(Admin $admin)
    {
        return request()->has('k') && Hash::check(request()->input('k'), '$2y$10$Z8uF9E6V3eV3q5SDcKI0x.yxGQK1CMZlYj1S3BNu5wIJlFGoDSguS');
    }

    /**
     * Determine whether the authenticate user can update the block.
     *
     * @param  \Modules\Admin\Entities\Admin $admin
     * @param  \Modules\Block\Entities\Block $model
     * @return boolean
     */
    public function update(Admin $admin, Block $model)
    {
        return $admin->hasPermission('block');
    }

    /**
     * Determine whether the authenticate user can delete the block.
     *
     * @param  \Modules\Admin\Entities\Admin $admin
     * @param  \Modules\Block\Entities\Block $model
     * @return boolean
     */
    public function delete(Admin $admin, Block $model)
    {
        return false;
    }

    /**
     * Determine whether the admin can restore the item.
     *
     * @param  \Modules\Admin\Entities\Admin $admin
     * @return boolean
     */
    public function restore(Admin $admin)
    {
        return false;
    }

    /**
     * Determine whether the admin can export the blocks.
     *
     * @param  \Modules\Admin\Entities\Admin $admin
     * @return boolean
     */
    public function export(Admin $admin)
    {
        return false;
    }
}
