<?php

namespace Modules\Block\Observers;

use Modules\Block\Entities\Block;

class BlockObserver
{
    /**
     * Handle the model "created" event.
     */
    public function created(Block $block): void
    {
        $block->updateQuietly([
            'slug' => str($block->title)->slug() . '-' . $block->id
        ]);
    }

    /**
     * Handle the model "updated" event.
     */
    public function updated(Block $block): void
    {
        // if ($block->wasChanged('title')) {
        //     $block->updateQuietly([
        //         'slug' => str($block->title)->slug() . '-' . $block->id
        //     ]);
        // }
    }

    /**
     * Handle the model "deleted" event.
     */
    public function deleted(Block $block): void
    {
        $block->updateQuietly([
            'is_active' => false
        ]);
    }

    /**
     * Handle the model "restored" event.
     */
    public function restored(Block $block): void
    {
        //
    }

    /**
     * Handle the model "force deleted" event.
     */
    public function forceDeleted(Block $block): void
    {
        //
    }
}
