<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('content_blocks', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->longText('editor_content');
            $table->longText('plain_content');
            $table->boolean('is_active')->default(0);
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('content_block_translations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('content_block_id')->constrained('content_blocks')->cascadeOnDelete();
            $table->string('language');
            $table->string('title');
            $table->longText('editor_content');
            $table->longText('plain_content');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('content_block_translations');
        Schema::dropIfExists('content_blocks');
    }
};
