<?php

namespace Modules\Announcement\Transformers;

use Illuminate\Http\Resources\Json\JsonResource;

class AnnouncementResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'hash' => $this->hash_id,
            'title' => $this->title,
            'message' => $this->message,
            'read' => (bool) $this->whenCounted('readDevices'),
            'created_timestamp' => $this->created_at?->timestamp,
            'created_date_formatted' => $this->created_at?->format('d/m/Y'),
            'created_time_formatted' => $this->created_at?->format('h:i A'),
        ];
    }
}
