<?php

use Illuminate\Support\Facades\Route;
use Modules\Announcement\Http\Controllers\AdminController;

Route::prefix('announcement')->name('announcement.')->group(function () {
    Route::controller(AdminController::class)->group(function () {
        Route::get('/', 'index')->name('index');

        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');

        Route::get('{announcement}/edit', 'edit')->name('edit');
        Route::put('{announcement}', 'update')->name('update');

        Route::delete('{announcement}', 'destroy')->name('destroy');

        Route::get('trashed', 'trashed')->name('trashed');
        Route::post('restore/{id}', 'restore')->name('restore');

        Route::get('export', 'export')->name('export');
    });
});
