
@inject('announcement', Modules\Announcement\Entities\Announcement::class)

@extends('admin.layouts.base', [
    'title' => __('Announcements Trashed'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-bullhorn fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('announcement.index') }}">{{ __('Announcements') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('Trashed') }}</li>

        @slot('buttons')
            <a href="{{ route('announcement.index') }}" class="btn btn-sm btn-neutral">{{ __('List All') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
<div class="container-fluid mt--8">
    <div class="card">
        <div class="py-4">
            <table id="tableAnnouncement" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        @canany(['restore'], $announcement)
                            <th>{{ __('Actions') }}</th>
                        @endcanany
                        <th>{{ __('Title') }}</th>
                        <th>{{ __('Message') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Deleted At') }}</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'Announcement',
    'route' => route('announcement.trashed'),
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $announcement, can: ['restore']),
        get_dt_column_config('title'),
        get_dt_column_config('message'),
        get_dt_column_config('status', 'is_active', searchable: false),
        get_dt_column_config('deleted_at', searchable: false),
    ]
])
