
@inject('announcement', Modules\Announcement\Entities\Announcement::class)

@extends('admin.layouts.base', [
    'title' => __('Announcements Management'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-bullhorn fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('announcement.index') }}">{{ __('Announcements') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('List All') }}</li>

        @slot('buttons')
            @can('create', $announcement)
                <a href="{{ route('announcement.create') }}" class="btn btn-sm btn-neutral">{{ __('Create New') }}</a>
            @endcan

            @can('export', $announcement)
                <a href="{{ route('announcement.export', request()->query()) }}" class="btn btn-sm btn-primary">{{ __('Export Excel') }}</a>
            @endcan
        @endslot
    @endcomponent
@endsection

@section('content')
<div class="position-relative container-fluid mt--8">
    <div class="card">
        @component('admin.components.filter')
            @slot('status', true)
        @endcomponent

        <div class="py-4">
            <table id="tableAnnouncement" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        @canany(['update', 'delete'], $announcement)
                            <th>{{ __('Actions') }}</th>
                        @endcanany
                        <th>{{ __('Title') }}</th>
                        <th>{{ __('Message') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Created At') }}</th>
                        <th>{{ __('Updated At') }}</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'Announcement',
    'route' => route('announcement.index'),
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $announcement, can: ['update', 'delete']),
        get_dt_column_config('title'),
        get_dt_column_config('message'),
        get_dt_column_config('status', 'is_active', searchable: false),
        get_dt_column_config('created_at', searchable: false),
        get_dt_column_config('updated_at', searchable: false),
    ]
])
