<div class="col-12 form-group">
    <label class="form-control-label" for="input-title">{{ __('Title') }} <sup class="text-danger">*</sup></label>
    <div class="{{ $errors->has('title') ? 'has-danger' : '' }}">
        <input type="text" name="title" id="input-title" class="form-control {{ $errors->has('title') ? 'is-invalid' : '' }}" maxlength="100" placeholder="{{ __('Title') }}" value="{{ old('title', $announcement->title) }}" autofocus required>
    </div>
    @include('alerts.feedback', ['field' => 'title'])
</div>

<div class="col-12 form-group">
    <label class="form-control-label" for="input-message">{{ __('Message') }} <small class="muted">({{ __('Max 200 Characters') }})</small></label>
    <div class="{{ $errors->has('message') ? 'has-danger' : '' }}">
        <textarea name="message" id="input-message" class="form-control {{ $errors->has('message') ? 'is-invalid' : '' }}" maxlength="200" cols="30" rows="5">{{ old('message', $announcement->message) }}</textarea>
    </div>
    @include('alerts.feedback', ['field' => 'message'])
</div>

<div class="col-12 form-group d-flex align-items-center">
    <label class="form-control-label mb-0 mr-3">{{ __('Status Active') }} <sup class="text-danger">*</sup></label>
    <label class="custom-toggle">
        <input type="checkbox" name="is_active" value="1" {{ old('is_active', $announcement->is_active) ? 'checked' : '' }}>
        <span class="custom-toggle-slider rounded-circle" data-label-off="No" data-label-on="Yes"></span>
    </label>
</div>

@push('js')
@endpush
