@extends('admin.layouts.base', [
    'title' => __('Edit Announcement'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-bullhorn fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('announcement.index') }}">{{ __('Announcements') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('Edit') }}</li>

        @slot('buttons')
            <a href="{{ route('announcement.index') }}" class="btn btn-sm btn-neutral">{{ __('List All') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
    <div class="container-fluid mt--8">
        <div class="row">
            <div class="col-xl-12 order-xl-1">
                @component('admin.components.form')
                    @slot('edit', true)
                    @slot('title', __('Edit Announcement') . ' #' . $announcement->id)
                    @slot('route', route('announcement.update', $announcement->hash_id))

                    @include('announcement::admin.form', ['announcement' => $announcement, 'edit' => true])
                @endcomponent
            </div>
        </div>
    </div>
@endsection

@push('css')
@endpush

@push('vendor-js')
@endpush

@push('js')
@endpush
